/* -LICENSE-START-
** Copyright (c) 2011 Blackmagic Design
**
** Permission is hereby granted, free of charge, to any person or organization
** obtaining a copy of the software and accompanying documentation covered by
** this license (the "Software") to use, reproduce, display, distribute,
** execute, and transmit the Software, and to prepare derivative works of the
** Software, and to permit third-parties to whom the Software is furnished to
** do so, all subject to the following:
** 
** The copyright notices in the Software and this entire statement, including
** the above license grant, this restriction and the following disclaimer,
** must be included in all copies of the Software, in whole or in part, and
** all derivative works of the Software, unless such copies or derivative
** works are solely in the form of machine-executable object code generated by
** a source language processor.
** 
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
** SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
** FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
** ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
** -LICENSE-END-
*/

#ifndef BMD_STREAMING_PREVIEW_PREVIEW_WINDOW_H__
#define BMD_STREAMING_PREVIEW_PREVIEW_WINDOW_H__

#include <atlbase.h>
#include <atltypes.h>
#include <atlwin.h>
#include <d3d9.h>

class PreviewWindow;

typedef void (*PreviewWindowClosedCb)(void*, PreviewWindow*);

class PreviewWindow
{
private:
	PreviewWindow(PreviewWindowClosedCb closedCb, void* ctx);
public:
	static PreviewWindow*	CreateInstance(PreviewWindowClosedCb closedCb, void* ctx);
	~PreviewWindow();

public:
	// Note: these are called from the Decoder Thread in the
	// the DecoderMF class.
	bool		SetMediaType(IMFMediaType* mediaType);
	bool		DrawFrame(IMFMediaBuffer* mediaBuffer);
	void		SetWindowSize(int width, int height);

private:
	bool		DoCreateWindow();
	static bool	DoCreateClass();

	bool reset();

private:
	LRESULT OnCreate(HWND hwnd, WPARAM wParam, LPARAM lParam);
	LRESULT OnDestroy(HWND hwnd, WPARAM wParam, LPARAM lParam);
	LRESULT OnPaint(HWND hwnd, WPARAM wParam, LPARAM lParam);
	LRESULT OnSize(HWND hwnd, WPARAM wParam, LPARAM lParam);

	static LRESULT CALLBACK PreviewWindowProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

private:
	HWND						m_hwnd;

    CComPtr<IDirect3D9>			m_d3d;
    CComPtr<IDirect3DDevice9>	m_device;
    CComPtr<IDirect3DSurface9>	m_surface;
	bool						m_needsReset;

	bool						m_newTextureInBuffer;

	UINT						m_width;
	UINT						m_height;
	UINT						m_defaultStride;


	CRITICAL_SECTION			m_criticalSection;

	PreviewWindowClosedCb		m_closedCb;
	void*						m_closedCbCtx;
};


#endif // BMD_STREAMING_PREVIEW_PREVIEW_WINDOW_H__
